<?php
/**
 * 发送微信模板消息接口
 */
class TempMsg{

    function  __construct(){
        $this->appid = C('WxConf.APPID');
        $this->secrect = C('WxConf.SECRET');
        $this->accessToken = $this->getToken();
    }
 
    /* 发送post请求 */
    function request_post($url = '', $param = ''){
        if (empty($url) || empty($param)) {
            return false;
        }
        $postUrl = $url;
        $curlPost = $param;
        $ch = curl_init(); //初始化curl
        curl_setopt($ch, CURLOPT_URL, $postUrl); //抓取指定网页
        curl_setopt($ch, CURLOPT_HEADER, 0); //设置header
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); //要求结果为字符串且输出到屏幕上
        curl_setopt($ch, CURLOPT_POST, 1); //post提交方式
        curl_setopt($ch, CURLOPT_POSTFIELDS, $curlPost);
        $data = curl_exec($ch); //运行curl
        curl_close($ch);
        return $data;
    }
 
 
    /* 发送get请求 */
    function request_get($url = ''){
        if (empty($url)) {
            return false;
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $data = curl_exec($ch);
        curl_close($ch);
        return $data;
    }
 
    /* 获取token */
    public function getToken(){
        if (S($this->appid)) {
            $access_token = S($this->appid);
        } else {
            $url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=".$this->appid."&secret=".$this->secrect;
            $token = $this->request_get($url);
            $token = json_decode(stripslashes($token));
            $arr = json_decode(json_encode($token), true);
            $access_token = $arr['access_token'];
            S($this->appid, $access_token, 7000);
        }
        return $access_token;
    }
 
    /**
     * [doSend 发送模版消息]
     * @param  [type] $touser      [OpenID]
     * @param  [type] $template_id [模板ID]
     * @param  [type] $url         [详情链接]
     */
    public function doSend($touser, $template_id, $url, $data, $topcolor = '#7B68EE'){
        $template = array(
            'touser'      => $touser,
            'template_id' => $template_id,
            'url'         => $url,
            'topcolor'    => $topcolor,
            'data'        => $data
        );
        $json_template = json_encode($template);
        $url = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=".$this->accessToken;
        $dataRes = $this->request_post($url, urldecode($json_template));
        if ($dataRes['errcode'] == 0) return true;
        else return false;
    }

    /**
     * [sendText 发送文字消息]
     * @param  [type] $openid [OpenID]
     * @param  [type] $text   [内容]
     */
    public function sendText($openid,$text){
        $parameters = array(
            'touser'  => $openid,
            'msgtype' => "text",
            'text'    => array("content" => $text)
        );
        $json_parameters = JSON($parameters);
        $url = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=".$this->accessToken;
        $dataRes = $this->request_post($url, urldecode($json_parameters));
        if ($dataRes['errcode'] == 0) return true;
        else return false;
    }


    /**
     * [getQRCode 生成带参二维码]
     * @param  [int] $scene_id
     */
    function getQRCode($scene_id){
        $qrcode = '{"action_name":"QR_LIMIT_SCENE","action_info":{"scene":{"scene_id": '.$scene_id.'}}}';
        $url = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=".$this->accessToken;
        $result = $this->request_post($url,$qrcode);
        $jsoninfo = json_decode($result,true);
        return "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=".$jsoninfo['ticket'];
    }
}
?>