<?php
class Packet{
	
	private $wxapi;
	private $wx_config;
	
	public function __construct($wx_config){
		$this->wx_config=$wx_config;
	}
	
    function _route($fun,$param = ''){
		@require_once "oauth2.php";
		$this->wxapi = new Wxapi($this->wx_config);
		switch ($fun)
		{
			case 'userinfo':
				return $this->userinfo($param);
				break;
			case 'wxpacket':
				return $this->wxpacket($param);
				break;
			case 'wxpacketadmin':
				return $this->wxpacket($param,true);
				break;			
			default:
				exit("Error_fun");
		}		
    }	
    /**
     * 用户信息
     * 
     */	
	private function userinfo($param){
       
		$get = $param['param'];
		$code = $param['code'];	
		if($get=='access_token' && !empty($code)){
			$json = $this->wxapi->get_access_token($code);
			if(!empty($json)){
				$userinfo = $this->wxapi->get_user_info($json['access_token'],$json['openid']);
				return $userinfo;
			}
		}else{
			
			$this->wxapi->get_authorize_url(WXAPPURL.SITE.'/index.php/Draw/checkLogin/id/'.$_GET['id'].'/openkey/'.$_GET['openkey'].'.html?param=access_token','STATE');
		}
	}
    /**
     * 微信红包
     * 
     */		
	private function wxpacket($param,$wxpacketadmin=false){
		if($wxpacketadmin){
			return $this->wxapi->pay($param['openid'],$wxpacketadmin);
		}else{
			return $this->wxapi->pay($param['openid']);
		}
	}
	
}
?>