<?php
class Wxapi {
	
    private $app_id = '';
    private $app_secret = '';
    private $app_mchid = '';
	private $send_name ="";
	
    function __construct($param){
		$this->id=$param['id'];
		$this->app_id=$param['app_id'];
		$this->app_secret=$param['app_secret'];
		$this->app_key=$param['app_key'];
		$this->app_mchid=$param['app_mchid'];
		$this->send_name=$param['send_name'];
		$this->nick_name=$param['nick_name'];
		$this->re_openid=$param['re_openid'];
		$this->total_amount=$param['total_amount'];
		$this->min_value=$param['min_value'];
		$this->max_value=$param['max_value'];
		$this->num=$param['num'];
		$this->shuiji=$param['shuiji'];
		$this->wishing=$param['wishing'];
		$this->client_ip=$param['client_ip'];
		$this->act_name=$param['act_name'];
		$this->remark=$param['remark'];
    }
    /**
     * 微信支付
     * 
     * @param string $openid 用户openid
     */
    public function pay($re_openid,$wxpacketadmin=false,$db=null)
    {
        include_once('WxHongBaoHelper.php');
        $commonUtil = new CommonUtil();
        $wxHongBaoHelper = new WxHongBaoHelper($this->app_key);

        $wxHongBaoHelper->setParameter("nonce_str", $this->great_rand());//随机字符串，丌长于 32 位
        $wxHongBaoHelper->setParameter("mch_billno", $this->app_mchid.date('YmdHis').rand(1000, 9999));//订单号
        $wxHongBaoHelper->setParameter("mch_id", "$this->app_mchid");//商户号
        $wxHongBaoHelper->setParameter("wxappid", "$this->app_id");
        $wxHongBaoHelper->setParameter("nick_name", "$this->nick_name");//提供方名称
        $wxHongBaoHelper->setParameter("send_name", "$this->send_name");//红包发送者名称
		
        $wxHongBaoHelper->setParameter("re_openid", "$re_openid");
		if($this->shuiji==1){
			$pricenum=rand($this->min_value,$this->max_value);
		}else{
			$pricenum=$this->total_amount;
		}
        $wxHongBaoHelper->setParameter("total_amount", $pricenum);//付款金额，单位分
        $wxHongBaoHelper->setParameter("min_value", $pricenum);//最小红包金额，单位分
        $wxHongBaoHelper->setParameter("max_value", $pricenum);//最大红包金额，单位分
        $wxHongBaoHelper->setParameter("total_num", 1);//红包収放总人数$this->num 现在只支持1个人
        $wxHongBaoHelper->setParameter("wishing", "$this->wishing");//红包祝福
        $wxHongBaoHelper->setParameter("client_ip", "$this->client_ip");//调用接口的机器 Ip 地址
        $wxHongBaoHelper->setParameter("act_name", "$this->act_name");//活劢名称
        $wxHongBaoHelper->setParameter("remark","$this->remark");//备注信息
        $postXml = $wxHongBaoHelper->create_hongbao_xml();
        $url = 'https://api.mch.weixin.qq.com/mmpaymkttransfers/sendredpack';
		$responseXml = $wxHongBaoHelper->curl_post_ssl($url,$postXml);
		$responseObj = simplexml_load_string($responseXml,'SimpleXMLElement',LIBXML_NOCDATA);
		$hongbao_user_cc=session('hongbao_user_xyz');//用户信息
		if($responseObj->return_code=='SUCCESS'){
			$total_amount=intval($responseObj->total_amount);
			$send_time=intval($responseObj->send_time);
			$data=array();
			$data['hongbaoid']=$this->id;
			$data['userid']=intval($hongbao_user_cc['id']);
			$data['username']=$hongbao_user_cc['nickname'];
			$data['sucerr']=1;
			$data['amount']=$total_amount;
			$data['opt_time']=time();
			$data['gzhname']=GZHNAME;
			M('Wx_log')->add($data);//写入日志
			M('Wx_code')->where('id='.$this->id)->setInc('ynum',1);
			if(!$wxpacketadmin){
				$this->echohtml('恭喜您！领取成功！');
			}	
		}else{
			$total_amount=intval($responseObj->total_amount);
			$data=array();
			$data['hongbaoid']=$this->id;
			$data['userid']=intval($hongbao_user_cc['id']);
			$data['username']=$hongbao_user_cc['nickname'];
			$data['sucerr']=0;
			$data['amount']=$total_amount;
			$data['opt_time']=time();
			$data['gzhname']=GZHNAME;
			M('Wx_log')->add($data);//写入日志
			if(!$wxpacketadmin){
				$this->echohtml('领取失败！'.$responseObj->return_msg);
			}
		}
		/*
		dump($responseXml);
		return $responseObj->return_code;*/
    }
	public function echohtml($msg=''){
		$confinfo=$this->get_js_sdk($this->app_id,$this->app_secret);
		echo '<!DOCTYPE HTML>
		<html lang="en-US">
			<head>
				<meta charset="UTF-8">
				<title></title>
				<script type="text/javascript" src="http://res.wx.qq.com/open/js/jweixin-1.0.0.js"></script>
			</head>
			<body>
			<script type="text/javascript">
			 wx.config({
				debug: false,
				appId: "'.$confinfo['appId'].'", // 必填，公众号的唯一标识
				timestamp: "'.$confinfo['timestamp'].'", // 必填，生成签名的时间戳
				nonceStr: "'.$confinfo['nonceStr'].'", // 必填，生成签名的随机串
				signature: "'.$confinfo['signature'].'",// 必填，签名，见附录1
				jsApiList: ["closeWindow"]
			});
			wx.ready(function(){
				alert("'.$msg.'");
				wx.closeWindow();
			});
			</script>
			<h1>'.$msg.'</h1>
			</body>
		</html>';
	}
	
    /**
     * 获取微信授权链接
     * 
     * @param string $redirect_uri 跳转地址
     * @param mixed $state 参数
     */
    public function get_authorize_url($redirect_uri = '', $state = '')
    {
		
		
        $redirect_uri = urlencode($redirect_uri);
		
        $url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid={$this->app_id}&redirect_uri={$redirect_uri}&response_type=code&scope=snsapi_userinfo&state={$state}#wechat_redirect";  
        
 	    echo "<script language='javascript' type='text/javascript'>";  
        echo "window.location.href='$url'";  
        echo "</script>";     
    }       
    
    /**
     * 获取授权token
     * 
     * @param string $code 通过get_authorize_url获取到的code
     */
    public function get_access_token($code = '')
    {
		//$app_id=$this->app_id . 'access_token';
		$res=true;
        if($res){
			$token_url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid={$this->app_id}&secret={$this->app_secret}&code={$code}&grant_type=authorization_code";
			$token_data = $this->http($token_url);
			if(!empty($token_data[0]))
			{
				$res=json_decode($token_data[0], TRUE);
				//S($app_id,$res,7150);
				return $res;
			}
			return FALSE;
		}else{
			return $res;
		}
    }   

    /**
     * 获取授权后的微信用户信息
     * 
     * @param string $access_token
     * @param string $open_id
     */
    public function get_user_info($access_token = '', $open_id = '')
    {
        if($access_token && $open_id)
        {
			$access_url = "https://api.weixin.qq.com/sns/auth?access_token={$access_token}&openid={$open_id}";
			$access_data = $this->http($access_url);
			$access_info = json_decode($access_data[0], TRUE);
			if($access_info['errmsg']!='ok'){
				exit('页面过期');
			}
            $info_url = "https://api.weixin.qq.com/sns/userinfo?access_token={$access_token}&openid={$open_id}&lang=zh_CN";
            $info_data = $this->http($info_url);  		
            if(!empty($info_data[0]))
            {
                return json_decode($info_data[0], TRUE);
            }
        }
        
        return FALSE;
    }   	
    /**
     * Http方法
     * 
     */ 
    public function http($url)
    {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_HEADER, false);
        $output = curl_exec($ch);//输出内容
        curl_close($ch);
        return array($output);
    }   

    /**
     * 生成随机数
     * 
     */     
    public function great_rand(){
        $str = '1234567890abcdefghijklmnopqrstuvwxyz';
        for($i=0;$i<30;$i++){
            $j=rand(0,35);
            $t1 .= $str[$j];
        }
        return $t1;    
    }
	/*******以下是获得微信浏览器js配置调用信息******/
	/*获得jsConfig*/
	public function get_js_sdk($APP_ID,$APP_SECRET){
		$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== off || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
		$url = $protocol.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
		
		$argu = array();
		$argu['appId'] = $APP_ID;
		$argu['url'] = $url;
		$argu['nonceStr'] = $this->createNonceStr();
		$argu['timestamp'] = time();
		
		$ACCESS_TOKEN = $this->get_accesstoken($APP_ID, $APP_SECRET);
		$argu['jsapi_ticket'] = $this->get_jsapi_ticket($ACCESS_TOKEN);
	
		$string = "jsapi_ticket=".$argu[jsapi_ticket]."&noncestr=".$argu[nonceStr]."&timestamp=".$argu[timestamp]."&url=".$argu[url];
		$argu['signature'] = sha1(trim($string));
		return $argu;
	}
	/**
	 * 调用接口获取 $ACCESS_TOKEN
	 * 微信缓存 7200 秒，这里使用thinkphp的缓存方法
	 * @param unknown $APP_ID
	 * @param unknown $APP_SECRET
	 * @return Ambigous <mixed, Thinkmixed, object>
	 */
	function get_accesstoken($APP_ID,$APP_SECRET){
		
		$ACCESS_TOKEN = S($APP_ID);
		if($ACCESS_TOKEN == false){
			$url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=".$APP_ID."&secret=".$APP_SECRET;
			$json = $this->curlSend($url);
			
			$data=json_decode($json,true);
				
			S($APP_ID,$data[access_token],7000);
			$ACCESS_TOKEN = S($APP_ID);
		}
	
		return $ACCESS_TOKEN;
	}
	/**
	 * 微信网页JSSDK  调用接口获取 $jsapi_ticket
	 * 微信缓存 7200 秒，这里使用thinkphp的缓存方法
	 * @param unknown $ACCESS_TOKEN
	 * @return Ambigous <mixed, Thinkmixed, object>
	 */
	function get_jsapi_ticket($ACCESS_TOKEN){
		$jsapi_ticket = S($ACCESS_TOKEN);
		//var_dump(S($ACCESS_TOKEN));exit;
		if($jsapi_ticket == false){
			$url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=".$ACCESS_TOKEN."&type=jsapi";
			$json = $this->curlSend($url);
			$data = json_decode($json,true);
			
			$aaa = S($ACCESS_TOKEN,$data[ticket],7000);
			$jsapi_ticket = S($ACCESS_TOKEN);
		}
	
		return $jsapi_ticket;
	}
	 /**
	 * php curl 请求链接
	 * 当$post_data为空时使用GET方式发送
	 * @param unknown $url
	 * @param string $post_data
	 * @return mixed
	 */
	function curlSend($url,$post_data=""){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,$url);
		if($post_data != ""){
			curl_setopt($ch,CURLOPT_POST,1);
			curl_setopt($ch,CURLOPT_POSTFIELDS,$post_data);
		}
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER,false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER,true);
	
		$result = curl_exec($ch);
		curl_close($ch);
		return $result;
	}
	/**
	 * 获取随机字符串
	 * @param number $length
	 * @return string
	 */
	function createNonceStr($length = 16) {
		$chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0153456789";
		$str = "";
		for ($i = 0; $i < $length; $i++) {
			$str .= substr($chars, mt_rand(0, strlen($chars) - 1), 1);
		}
		return $str;
	}
	function ticket_hq($uid,$access_token){
		$qrcode='{"action_name":"QR_LIMIT_SCENE","action_info":{"scene":{"scene_id": '.$uid.'}}}';
		$url2="https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=$access_token";
		$result=$this->curlSend($url2,$qrcode);
		$jsoninfo2=json_decode($result,true);
		$ticket=$jsoninfo2['ticket'];
		return $ticket;
	}
}
?>