<?php
namespace Api\Model;
use Think\Model;
header("Content-type:text/html;charset=utf-8");
class OtherModel extends Model{
    /**
     * 分类
     */
    //顶一个默认的数据库表
    protected  $tableName = 'wx_users';
    //初始化数据库表
    private $table = '';

    //添加数据
    function addData($tableName, $data)
    {
        $this->table = $tableName;

        return M($this->table)->add($data);
    }

    //删除数据
    function deleData($tableName, $where)
    {
        $this->table = $tableName;

        return M($this->table)->where($where)->delete();
    }

    //修改数据
    function saveData($tableName, $where, $data)
    {
        $this->table = $tableName;

        return M($this->table)->where($where)->save($data);
    }

    //查找单个数据
    function findData($tableName, $where, $field)
    {
        $this->table = $tableName;
        return M($this->table)->field($field)->where($where)->find();
    }

    //查找全部数据->join("a LEFT JOIN `xcx_users` u ON a.`openid`=u.`openid`")
    function findAllData($tableName, $where, $field, $num)
    {
        $this->table = $tableName;

        if ($tableName == 'goods') {
            return M($this->table)->field($field)->where($where)->order('sort desc, create_time desc')->limit($num)->select();
        } elseif ($tableName == 'broadcast' || $tableName == 'image_manage') {
            return M($this->table)->field($field)->where($where)->order('sort asc, create_time desc')->limit($num)->select();
        } elseif ($tableName == 'store') {
            return M($this->table)->field($field)->where($where)->order('type asc')->limit($num)->select();
        } elseif ($tableName == 'integral_share666') {
            $where1 = '';
            if ($where['admin_id']) $where1['m.admin_id'] = $where['admin_id'];
            if ($where['sopenid']) $where1['m.sopenid'] = $where['sopenid'];

            return M($tableName)->field('m.*')->join('m LEFT JOIN `tbl_wx_users` j ON j.openid = m.openid')->where($where1)->order('m.create_time desc')->limit($Page->firstRow.','.$Page->listRows)->select();
        } else return M($this->table)->field($field)->where($where)->order('create_time desc')->limit($num)->select();
        
    }

    //查找单个字段
    function getFieldData($tableName, $where, $string)
    {
        $this->table = $tableName;

        return M($this->table)->where($where)->getField($string);
    }

    //统计某个字段的数据总和
    function sumData($tableName, $where, $string)
    {
        $this->table = $tableName;
        return M($this->table)->where($where)->sum($string);
    }

    //商品的销量和库存量增涨
    function saveIncDec($tableName, $where, $string, $num, $type)
    {
        $this->table = $tableName;
        if ($type == 1) return M($this->table)->where($where)->setInc($string, $num);
        else return M($this->table)->where($where)->setDec($string, $num);
    }


    //积分商品查询
    function j_goods($tableName, $where, $type)
    {
        if ($type == 1) {
            return M($tableName)->where($where)->order('goodsPrice asc')->select();
        } elseif ($type == 2) {
            return M($tableName)->where($where)->order('sale_num asc')->select();
        } elseif ($type == 3) {
            return M($tableName)->where($where)->order('create_time asc')->select();
        } elseif ($type == -1) {
            return M($tableName)->where($where)->order('goodsPrice desc')->select();
        } elseif ($type == -2) {
            return M($tableName)->where($where)->order('sale_num desc')->select();
        } elseif ($type == -3) {
            return M($tableName)->where($where)->order('create_time desc')->select();
        }
    }

    //商品排序查询
    function goods_sort($tableName, $where, $type)
    {
        if ($type == 1) {
            return M($tableName)->where($where)->order('id asc')->select();
        } elseif ($type == 2) {
            return M($tableName)->where($where)->order('price desc')->select();
        } elseif ($type == 3) {
            return M($tableName)->where($where)->order('create_time desc')->select();
        } elseif ($type == -1) {
            return M($tableName)->where($where)->order('id desc')->select();
        } elseif ($type == -2) {
            return M($tableName)->where($where)->order('price asc')->select();
        } elseif ($type == -3) {
            return M($tableName)->where($where)->order('create_time asc')->select();
        }
    }







}
