<?php
namespace Api\Controller;
use Think\Controller;
header("Content-Type: text/html; charset=utf-8");
class WxPayController extends Controller {
	public function _initialize()
    {
        //引入WxPayPubHelper
        vendor('WxPayPubHelper.WxPayPubHelper');
    }

    function getParams()
    {
        if (I('openid') == undefined || I('openid') == null || I('openid') == '') $this->ajaxReturn(array('status' => -1, 'msg' => 'openid参数获取失败'));
        if (I('order_sn') == undefined || I('openid') == null || I('openid') == '') $this->ajaxReturn(array('status' => -2, 'msg' => '订单号获取失败'));
        if (!I('type')) $this->ajaxReturn(array('status' => -3, 'msg' => '支付类型获取失败'));
        $order_sn = I('order_sn');
        if (I('type') == 'effect') {
            //设置数据库表
            session('tableName', null);
            session('tableName', 'effect_goods_order');
            $payname = "碳币特权订单支付";
            $order = D('Common')->findData(array('order_sn' => I('order_sn')), 'price');
            if (!$order) $this->ajaxReturn(array('status' => -4, 'msg' => '该订单不存在'));
            $price = $order['price'];
        }

        //唤醒微信支付
        $data = $this->wxpay(I('openid'), I('order_sn'), $price, I('type'), $payname);

        $this->ajaxReturn($data);
    }

    function wxpay($openid, $order_sn, $price, $type, $payname)
    {
        //=========步骤1：设置微信支付必要参数============
        //使用统一支付接口
        //设置统一支付接口参数
        //设置必填参数
        /*将获取的参数放到数组中*/   
        $price = 0.01;
        //设置回调地址
        if ($type == 'effect') $notify_url = "http://" . $_SERVER['HTTP_HOST'] . '/tbb/Api/WxPay/effect';

        //设置必填参数
        $jsApi = new \JsApi_pub();
        $unifiedOrder = new \UnifiedOrder_pub();
        $unifiedOrder->setParameter('openid', $openid);
        $unifiedOrder->setParameter('body', $payname);
        $unifiedOrder->setParameter('out_trade_no', $order_sn);//商户订单号
        $unifiedOrder->setParameter('total_fee', $price * 100);//订单金额
        $unifiedOrder->setParameter('trade_type', 'JSAPI');//交易类型
        $unifiedOrder->setParameter('notify_url', $notify_url);//通知回调函数

        //=========步骤2：prepay_id 调用结果============
        $prepayIdResult = $unifiedOrder->getPrepayId(); // prepay_id 调用结果 [array]

        //判断支付准备状态
        if ($prepayIdResult['return_code'] == 'FAIL') {
            //微信支付失败记录
            // file_put_contents('./Logs/paylog.log', date('Y-m-d H:i:s').'支付错误返回码：'.$prepayIdResult['return_msg'] . "\r\n\r\n", FILE_APPEND);
            $data = array('status' => 0, 'msg' => '支付配置失败', 'error'=> $prepayIdResult["return_msg"]);
        } else {
            //=========步骤3：使用jsapi调起支付============
            $jsApi->setPrepayId($prepayIdResult['prepay_id']);
            $jsApiParameters = $jsApi->getParameters();
           // file_put_contents('./Logs/paylog.log', date('Y-m-d H:i:s').'支付成功的记录：'.serialize($jsApiParameters) . "\r\n\r\n", FILE_APPEND);
            $data = array('status' => 1, 'msg' => '支付配置成功', 'data' => json_decode($jsApiParameters));
        }

        return $data;
    }

    /**
     * 支付回调更新碳币特权订单信息
     * @return [type] [description]
     */
    function effect()
    {
        $notify = new \Notify_pub();
        $xml = $GLOBALS['HTTP_RAW_POST_DATA'];
        $notify -> saveData($xml);
        $msg = array();
        $msg = (array)simplexml_load_string($xml, 'SimpleXMLElement', LIBXML_NOCDATA);
        if($notify->checkSign() == FALSE){
            $notify->setReturnParameter("return_code","FAIL");//返回状态码
            $notify->setReturnParameter("return_msg","签名失败");//返回信息
        }else{
            $notify->setReturnParameter("return_code","SUCCESS");//设置返回码
        }
        $returnXml = $notify->returnXml();
        if($notify->checkSign() == TRUE){
            if ($notify->data["return_code"] == "FAIL") {
            //通信出错，此处应该更新一下定单状态，商户自行增删操作
            }elseif($notify->data["result_code"] == "FAIL"){
            //业务出错，此处应该更新一下定单状态，商户自行增删操作
            }else{
                // file_put_contents("./Logs/paylog.log", date("Y-m-d H:i:s") . '支付成功回调返回信息：' . serialize($msg) . "\r\n\r\n", FILE_APPEND);
                //支付成功，此处应该更新一下定单状态，商户自行增删操作
                $order_sn = $msg['out_trade_no'];
                $data['status'] = 1;
                $where["order_sn"] =  $order_sn;
                $data['pay_time'] = time();
                M("effect_goods_order")->where($where)->save($data);

                /*******支付成功解锁商品*****/
                $orderData = M('effect_goods_order')->field('openid, goods, phone')->where($where)->find();
                $goods = unserialize($orderData['goods']);
                foreach ($goods as $key => $value) {
                    //判断用户是否已经解锁过了该商品
                    $is_good =  M('effect_unlock')->where(array('goodid' => $value['id'], 'openid' => $orderData['openid']))->find();
                    if (!$is_good) {
                        $lockData = array(
                            'openid' => $orderData['openid'],
                            'goodid' => $value['id'],
                            'order_sn' => $order_sn,
                            'create_time' => time()
                        );
                        M('effect_unlock')->add($lockData);
                    } else {
                        //如果有该商品，则判断是否为赠送商品（用手机号码去判断）
                        //取出用户的第一次手机号码
                        $firstPhone = M('wx_users')->where(array('openid' => $orderData['openid']))->getField('phone');
                        if ($orderData['phone'] != $firstPhone) {
                            $giveData = array(
                                'openid' => $orderData['openid'],
                                'goodid' => $value['id'],
                                'order_sn' => $order_sn
                            );
                            M('effect_give')->add($giveData);
                        }
                    }
                }

                //分销用户的收益
                // D('Users')->shareProfit($order_sn, 'broken');

                //记录支付订单信息
                $paydata = array(
                    'openid' => $msg['openid'], 
                    'order_sn' => $msg['out_trade_no'],
                    'money' => $msg['total_fee']/100,
                    'transaction_id' => $msg['transaction_id'],
                    'result_code' => $msg['result_code'],
                    'log' => serialize($msg),
                    'type' => 1,
                    'create_time' => time(),
                );
                if($msg["result_code"] == "FAIL"){
                    $data['err_code'] = $msg['err_code'];
                    $data['err_code_des'] = $msg['err_code_des'];
                }
                M("order_payinfo")->add($paydata);
                exit('SUCCESS');
          }
       }
    }







}