<?php
namespace Api\Controller;
use Think\Controller;
class WeChatController extends Controller {
    public function index(){
        define("TOKEN", "kb44Zhd1m1Y5M125uYts1Xd60f56ldUO");
        ob_clean();
        if (!isset($_GET['echostr'])) {
            $this->responseMsg();
        }else{
            $this->valid();
        }
    }
    //Token验证
    public function valid(){
        $echoStr   = $_GET["echostr"];
        $signature = $_GET["signature"];
        $timestamp = $_GET["timestamp"];
        $nonce     = $_GET["nonce"];
        $token     = TOKEN;
        $tmpArr    = array($token, $timestamp, $nonce);
        sort($tmpArr);
        $tmpStr = sha1(implode($tmpArr));
        if($tmpStr == $signature){
            echo $echoStr;
            exit;
        }
    }
    
    //响应消息
    public function responseMsg(){
        $postStr = $GLOBALS["HTTP_RAW_POST_DATA"];
        if (!empty($postStr)){
            $this->logger("R ".$postStr);
            $postObj = simplexml_load_string($postStr, 'SimpleXMLElement', LIBXML_NOCDATA);
            $RX_TYPE = trim($postObj->MsgType);
             
            //消息类型分离
            switch ($RX_TYPE){
                case "event":
                    $result = $this->receiveEvent($postObj);
                    break;
                case "text":
                    $result = $this->receiveText($postObj);
                    break;
                default:
                    $result = "unknown msg type";
                    break;
            }
            $this->logger("T ".$result);
            echo $result;
        }else {
            echo "";
            exit;
        }
    }
    
    // 处理文本消息
    private function receiveText($object){
        $keyword = trim($object->Content);
        if(is_array($content)){
            if (isset($content[0]['PicUrl'])){
                $result = $this->transmitNews($object, $content);
            }
        }else{
            $result = $this->transmitTextSer($object, $content);
        }
        return $result;
    }

    // 处理事件消息
    public function receiveEvent($object){
        $content = "";
        switch ($object->Event){
            // 关注事件
            case "subscribe":
                $openid = trim($object->FromUserName);
                $users = M('wx_users');
                $userinfo = $users->where("openid = '{$openid}'")->find();
                $userinfo['subscribe'] = 1;
                if(!$userinfo['uid']){
                    $userinfo['openid']      = $openid;
                    $userinfo['create_time'] = time();
                    $users->add($userinfo);
                }else{
                    $users->save($userinfo);
                }
                $content[] = array(
                    "Title"=>"点我",
                    "Description"=>"愣啥，点我",
                    "PicUrl"=>'http://'.$_SERVER['HTTP_HOST']."/welcome.jpg",
                    "Url" =>'http://'.$_SERVER['HTTP_HOST']."/Index/index"
                    );
                break;
            // 取消关注事件
            case "unsubscribe":
                $openid = trim($object->FromUserName);
                M('wx_users')->where("openid = '{$openid}'")->delete();
                break;
            default:
                break;
        }

        if(is_array($content)){
            if (isset($content[0]['PicUrl'])){
                $result = $this->transmitNews($object, $content);
            }else if (isset($content['MusicUrl'])){
                $result = $this->transmitMusic($object, $content);
            }
        }else{
            if(!empty($content)){
                $result = $this->transmitText($object, $content);
            }
        }
        return $result;
    }
    
    // 回复文本消息
    private function transmitText($object, $content){
        $xmlTpl = "<xml>
            <ToUserName><![CDATA[%s]]></ToUserName>
            <FromUserName><![CDATA[%s]]></FromUserName>
            <CreateTime>%s</CreateTime>
            <MsgType><![CDATA[text]]></MsgType>
            <Content><![CDATA[%s]]></Content>
            </xml>";
        $result = sprintf($xmlTpl, $object->FromUserName, $object->ToUserName, time(), $content);
        return $result;
    }
    /* 回复图片消息 */
    private function return_img($postObj,$media_id){
        $textTpl = "
            <xml>
            <ToUserName><![CDATA[%s]]></ToUserName>
            <FromUserName><![CDATA[%s]]></FromUserName>
            <CreateTime>%s</CreateTime>
            <MsgType><![CDATA[image]]></MsgType>
            <Image>
            <MediaId><![CDATA[%s]]></MediaId>
            </Image>
            </xml>";
        $time = time();
        $resultStr = sprintf($textTpl, $postObj->FromUserName, $postObj->ToUserName, $time, $media_id);
        echo $resultStr;
        exit;
    }
    // 回复图文消息
    private function transmitNews($object, $newsArray){
        if(!is_array($newsArray)){
            return;
        }
        $itemTpl = "<item>
            <Title><![CDATA[%s]]></Title>
            <Description><![CDATA[%s]]></Description>
            <PicUrl><![CDATA[%s]]></PicUrl>
            <Url><![CDATA[%s]]></Url>
            </item>
            ";
        $item_str = "";
        foreach ($newsArray as $item){
            $item_str .= sprintf($itemTpl, $item['Title'], $item['Description'], $item['PicUrl'], $item['Url']);
        }
        $xmlTpl = "<xml>
            <ToUserName><![CDATA[%s]]></ToUserName>
            <FromUserName><![CDATA[%s]]></FromUserName>
            <CreateTime>%s</CreateTime>
            <MsgType><![CDATA[news]]></MsgType>
            <ArticleCount>%s</ArticleCount>
            <Articles>$item_str</Articles>
            </xml>";
        $result = sprintf($xmlTpl, $object->FromUserName, $object->ToUserName, time(), count($newsArray));
        return $result;
    }
    // 处理客服消息
    private function transmitTextSer($object, $content){
        $xmlTpl = "<xml>
            <ToUserName><![CDATA[%s]]></ToUserName>
            <FromUserName><![CDATA[%s]]></FromUserName>
            <CreateTime>%s</CreateTime>
            <MsgType><![CDATA[transfer_customer_service]]></MsgType>
            <Content><![CDATA[%s]]></Content>
            </xml>";
        $result = sprintf($xmlTpl, $object->FromUserName, $object->ToUserName, time(), $content);
        return $result;
    }



    private function logger($log_content)
    {
        if(isset($_SERVER['HTTP_APPNAME'])){   //SAE
            sae_set_display_errors(false);
            sae_debug($log_content);
            sae_set_display_errors(true);
        }else if($_SERVER['REMOTE_ADDR'] != "127.0.0.1"){ //LOCAL
            $max_size = 10000;
            $log_filename = "log.xml";
            if(file_exists($log_filename) and (abs(filesize($log_filename)) > $max_size)){unlink($log_filename);}
            file_put_contents($log_filename, date('H:i:s')." ".$log_content."\r\n", FILE_APPEND);
        }
    }
}