<?php

namespace Api\Controller;
use Think\Controller;

class TestController extends Controller{
	protected $table = array();
	function __construct(){
		//初始化数据库表
		$tables= array(
			'frim_image' => 'frim_image',
			'store' => 'store'

		);
		return $this->table = $tables;
	}

    function server_list()
    {
        $admin_id = I('admin_id')?:-2;
        $result = M('server_list')->where(['admin_id' => $admin_id])->select();
        if ($result) {
            foreach ($result as $key => $value) {
                if ($value['image_url']) {
                    $result[$key]['image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $value['image_url'];
                }
            }
            $data = ['status' => 1, 'msg' => '数据获取成功', 'data' => $result];
        } else {
            $data = ['status' => 0, 'msg' => '暂无数据'];
        }
        $this->ajaxReturn($result);
    }

	function store()
    {
        //初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id')?:-2;
        $model = D('Other');
        $result = $model->findAllData($tableName['store'], array('admin_id' => $admin_id), '');
       
        if ($result) {       
        	foreach ($result as $k => $val) {
        		$tengXun = $this->Convert_BD09_To_GCJ02($val['lat'],$val['long']);
                $result[$k]['long'] = $tengXun['lng'];
                $result[$k]['lat'] = $tengXun['lat'];
        	}
            

            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '暂无数据');

        $this->ajaxReturn($data);
    }

    function storeDetails()
    {
    	$tableName = $this->table;
        $admin_id = I('admin_id')?:-2;
        $model = D('Other');
        $result = $model->findData($tableName['store'], array('admin_id' => $admin_id, 'id' => I('id')), '');
        if ($result) {
        	//查找门店的图片
            $imageArr= $model->findAllData($tableName['frim_image'], array('admin_id' => $admin_id, 'type' => $result['type']), '', '');
            foreach ($imageArr as $key => $value) {
            	$imageArr[$key]['image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $value['image_url'];
            }

            $result['imageArr'] = $imageArr;
        	$data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '暂无数据');

        $this->ajaxReturn($data);
    }

    //百度地图转化成为正常地图坐标点
    function Convert_BD09_To_GCJ02($lat,$lng){  
        $x_pi = 3.14159265358979324 * 3000.0 / 180.0;  
        $x = $lng - 0.0065;  
        $y = $lat - 0.006;  
        $z = sqrt($x * $x + $y * $y) - 0.00002 * sin($y * $x_pi);  
        $theta = atan2($y, $x) - 0.000003 * cos($x * $x_pi);  
        $lng = $z * cos($theta);  
        $lat = $z * sin($theta);  
        return array('lng'=>$lng,'lat'=>$lat);  
    } 

	
	
}