<?php

/**
 * @Author: Administrator
 * @Date:   2017-11-24 18:19:02
 * @Last Modified by:   Administrator
 * @Last Modified time: 2018-10-10 10:56:06
 */
namespace Api\Controller;

use Think\Controller;

class IntegralController extends Controller
{
	protected $table = [];
	function __construct()
	{
		parent::__construct();
		$tables = [
			'integral_share' => 'integral_share',
			'integral_setting' => 'integral_setting',
			'integral_order' => 'integral_order',
			'integral_goods' => 'integral_goods',
			'wx_users' => 'wx_users',
			'integral_sign' => 'integral_sign'
		];

		return $this->table = $tables;
	}

	//推客记录
    function myUser()
    {
        //初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id')?:-2;
        $openid = I('openid');
        $result = D('Other')->findAllData($tableName['integral_share'], array('admin_id' => $admin_id, 'sopenid' => $openid), '', '');
        if ($result) {
        	foreach ($result as $key => $value) {
        		$result[$key]['create_time'] = date('Y-m-d H:i', $value['create_time']);
                $user = D('Other')->findData($tableName['wx_users'], array('openid' => $value['openid']), 'nickname, headimgurl', '');
                $result[$key]['nickname'] = $user['nickname'];
                $result[$key]['headimgurl'] = $user['headimgurl'];
        	}
            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '暂无数据');

        $this->ajaxReturn($data);
    }

    //检查积分
    function checkGrade()
    {
    	//初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id')?:-2;
        $openid = I('openid');
        $goods_id = I('id');
        $model = D('Other');
        $user = $model->findData($tableName['wx_users'], array('admin_id' => $admin_id, 'openid' => $openid), 'grade');
        $goods = $model->findData($tableName['integral_goods'], array('admin_id' => $admin_id, 'id' => $goods_id), 'goodsPrice');
        if ($user['grade'] < $goods['goodsPrice']) {
            $data = array('status' => 0, 'msg' => '您的积分不足');
        } else $data = array('status' => 1, 'msg' => '积分充足');

        $this->ajaxReturn($data);
    }

    //我的积分
    function myGrade()
    {
    	//初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id')?:-2;
        $openid = I('openid');
        $result = D('Other')->findData($tableName['wx_users'], array('admin_id' => $admin_id, 'openid' => $openid), 'grade');
        if ($result) {
            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '暂无数据');

        $this->ajaxReturn($data);
    }

    //积分商品
    function goodsList()
    {
    	//初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id')?:-2;
        //排序条件1:积分排序，2销量，3最新
        $sort = I('sort')?:1;
        $where['admin_id'] = $admin_id;
        $where['goods_num'] = array('gt', 0);
        $where['is_sale'] = 0;
        if (I('goodsName')) $where['goodsName'] = array('like', '%'.I('goodsName').'%');
        $result = D('Other')->j_goods($tableName['integral_goods'], $where, $sort);
        if ($result) {
        	foreach ($result as $key => $value) {
        		$result[$key]['image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $value['image_url'];
        	}
            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '暂无数据');

        $this->ajaxReturn($data);
    }

    function goodsDetails()
    {
    	//初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id')?:-2;
        $goods_id = I('id');
        $result = D('Other')->findData($tableName['integral_goods'], array('admin_id' => $admin_id, 'id' => $goods_id), '');
        if ($result) {
        	$result['image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $result['image_url'];
            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '该商品不存在');

        $this->ajaxReturn($data);
    }


    //积分商城下单
    function comfirm()
    {
    	$tableName = $this->table;
    	$admin_id = I('admin_id')?:-2;
    	$goods_id = I('id');
    	$goods_num = I('goods_num')?:1;
	    $data = [
	     	'order_sn' => 'JS' . rand(100000000, 999999999),
	     	'openid' => I('openid'),
	     	'goods_id' => I('id'),
	    	'admin_id' => $admin_id,
	    	'username' => I('username'),
	    	'phone' => I('phone'),
	    	'address' => I('address'),
	    	'status' => 0,
	    	'create_time' => time(),
	    	'goods_num' => $goods_num
	    ];

	    $goods_id = I('id');
	    if(I('openid') == undefined || I('openid') == null || I('openid')== ''){$this->ajaxReturn(array('status' => 0, 'msg' => '网络错误'));die;}
	    if(I('username') == undefined || I('username') == null || I('username')== ''){$this->ajaxReturn(array('status' => 0, 'msg' => '请填写用户名'));die;}
	    if(I('phone') == undefined || I('phone') == null || I('phone')== ''){$this->ajaxReturn(array('status' => 0, 'msg' => '请填写您的手机号码'));die;}
	    if(I('address') == undefined || I('address') == null || I('address')== ''){$this->ajaxReturn(array('status' => 0, 'msg' => '请填写收货地址'));die;}
        $goods = D('Other')->findData($tableName['integral_goods'], array('admin_id' => $admin_id, 'id' => $goods_id), '');

        if ($goods) {
        	//判断库存
        	if ($goods['goodsNum'] > $goods_num || $goods['goodsNum'] == $goods_num) {
        		$data['goodsPrice'] = $goods_num * $goods['goodsPrice'];
        		$data['goodsName'] = $goods['goodsName'];
        		$data['image_url'] = $goods['image_url'];

                //判断用户的积分是否充足
                $user = D('Other')->findData($tableName['wx_users'], array('admin_id' => $admin_id, 'openid' => $data['openid']), 'grade');
        		if (intval($user['grade']) < $data['goodsPrice']) {
                    $this->ajaxReturn(array('status' => 0, 'msg' => '您的积分不足'));die;
        		} else {
                    $model = M($tableName['integral_order']);
                    $model->startTrans();//开启事务
                    $res = $model->add($data);
                    if ($res) {
                        //下单成功，减少积分
                        D('Other')->saveIncDec($tableName['wx_users'], array('admin_id' => $admin_id, 'openid' => $data['openid']), 'grade', $data['goodsPrice'], 2);
                        //下单成功，减少库存
                        D('Other')->saveIncDec($tableName['integral_goods'], array('admin_id' => $admin_id, 'id' => $goods_id), 'goodsNum', $goods_num, 2);
                        //下单成功，销量增加
                        D('Other')->saveIncDec($tableName['integral_goods'], array('admin_id' => $admin_id, 'id' => $goods_id), 'sale_num', 1, 1);
                        $model->commit();//事务提交
                        $this->ajaxReturn(array('status' => 1, 'msg' => '下单成功', 'order_sn' => $data['order_sn']));die;
                    } else {
                        $model->rollback();
                        $this->ajaxReturn(array('status' => 0, 'msg' => '下单失败'));die;
                    }
        		}
        		
        	} else {
        		$this->ajaxReturn(array('status' => 0, 'msg' => '库存不足'));die;
        	}
        } else {
        	$this->ajaxReturn(array('status' => 0, 'msg' => '该商品不存在'));die;
        }
	    
    }

    //我的订单列表
    function orderList()
    {
    	//初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id')?:-2;
        $openid = I('openid');
        //订单查询条件
        $status = I('status')?:0;
        $where = [
        	'admin_id' => $admin_id,
        	'openid' => $openid
        ];
        if ($status == 1) $where['status'] = 0; 
        if ($status == 2) $where['status'] = 1; 
        if ($status == 3) $where['status'] = 2; 
        $result = D('Other')->findAllData($tableName['integral_order'], $where, '', '');
        if ($result) {       	
        	foreach ($result as $key => $value) {
        		$result[$key]['image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $value['image_url'];
        		$result[$key]['create_time'] = date('Y-m-d H:i', $value['create_time']);
        	}
            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '暂无数据');

        $this->ajaxReturn($data);
    }

    //检查签到功能
    function checkSign()
    {
    	//初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id')?:-2;
        $model = D('Other');
        if(I('openid') == undefined || I('openid') == null || I('openid')== ''){$this->ajaxReturn(array('status' => 0, 'msg' => '网络错误'));die;}
        //判断签到功能是否开启
        $sign = $model->findData($tableName['integral_setting'], array('admin_id' => $admin_id), '');
        if ($sign['status'] == 0) {
        	//判断用户是否已经签到了
        	$stime = time();
            $time=strtotime(date("Y-m-d",$stime));  
            $time1=$time+86400;
            $where1 = array(
                'create_time' => array('between', array($time, $time1)),
                'openid' => I('openid'),
                'admin_id' => $admin_id
            );
            $user = $model->findData($tableName['integral_sign'], $where1, '');
            if (!$user) {
            	$this->ajaxReturn(array('status' => 1, 'msg' => '可以签到'));
            } else {
            	$this->ajaxReturn(array('status' => -1, 'msg' => '您今天已经签到过了'));
            }
        } else {
        	$this->ajaxReturn(array('status' => 0, 'msg' => '商家暂未开通签到功能'));
        }
    }

    //签到功能
    function doSign()
    {
    	//初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id')?:-2;
        $model = D('Other');
        if(I('openid') == undefined || I('openid') == null || I('openid')== ''){$this->ajaxReturn(array('status' => 0, 'msg' => '网络错误'));die;}
        //判断签到功能是否开启
        $sign = $model->findData($tableName['integral_setting'], array('admin_id' => $admin_id), '');
        if ($sign && $sign['status'] == 0) {
        	//判断用户是否已经签到了
        	$stime = time();
            $time=strtotime(date("Y-m-d",$stime));  
            $time1=$time+86400;
            $where1 = array(
                'create_time' => array('between', array($time, $time1)),
                'openid' => I('openid'),
                'admin_id' => $admin_id
            );
            $user = $model->findData($tableName['integral_sign'], $where1, '');
            $add_grade = $sign['sign_grade']?:0;
            if (!$user) {
            	$data = [
            		'openid' => I('openid'),
            		'admin_id' => $admin_id,
            		'grade' => $add_grade,
                    'create_time' => time()
            	];
            	$res = $model->addData($tableName['integral_sign'], $data);
            	if ($res) {
            		//用户的积分累加
                    $openid = I('openid');
            		$model->saveIncDec($tableName['wx_users'], array('openid' => $openid, 'admin_id' => $admin_id), 'grade', $add_grade, 1);
            		$this->ajaxReturn(array('status' => 1, 'msg' => '签到成功'));
            	} else {
            		$this->ajaxReturn(array('status' => 0, 'msg' => '签到失败'));
            	}
            } else {
            	$this->ajaxReturn(array('status' => 0, 'msg' => '您今天已经签到过了'));
            }
        } else {
        	$this->ajaxReturn(array('status' => 0, 'msg' => '商家暂未开通签到功能'));
        }
        
    }
}