<?php

namespace Api\Controller;
use Think\Controller;

class IndexController extends Controller{
    protected $table = array();
    function __construct(){
        //初始化数据库表
        $tables= array(
            'image_manage' => 'image_manage',
            'goods' => 'goods',
            'company_news' => 'company_news',
            'goods_catorage' => 'goods_catorage',
            'company_news_type' => 'company_news_type',
            'setting' => 'setting',
            'componay_news_view' => 'componay_news_view',
            'goods_view' => 'goods_view',
            'broadcast' => 'broadcast',
            'contact_type' => 'contact_type',
            'contact_us' => 'contact_us',
            'setting_info' => 'setting_info',
            'frim_image' => 'frim_image',
			'store' => 'store'
        );

        return $this->table = $tables;
    }

    //首页轮播图
    function bannerIcon()
    {
        //初始化数据库表
        $tableName = $this->table;
        $type = I('type') ?: 0;
        $admin_id = I('admin_id')?:-1;

        $result = D('Other')->findAllData($tableName['image_manage'], array('cid' => $type, 'admin_id' => $admin_id));
        if ($result) {
            foreach ($result as $key => $value) {
                $result[$key]['image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $value['image_url'];
            }

            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '暂无数据');
        $this->ajaxReturn($data);
    }

    //产品分类
    function goodsCatorage()
    {
        //初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id')?:-1;
        $result = D('Other')->findAllData($tableName['goods_catorage'], array('admin_id' => $admin_id), '');
        if ($result) {
            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '暂无数据');

        $this->ajaxReturn($data);
    }
    //产品展示
    function goodShow()
    {
        //初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id')?:-1;
        $where = array(
            'total_num' => array('gt',0),
            'is_sale' => 0,
            'admin_id' => $admin_id
        );
        //获取分类ID
        if (I('cid')) $where['cid'] = I('cid');
        $result = D('Other')->findAllData($tableName['goods'], $where, 'id, goodsName, sm_image_url, price, total_num, goodsDes, image_url');
        if ($result) {
            foreach ($result as $key => $value) {
                $result[$key]['image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $value['image_url'];
                $result[$key]['sm_image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $value['sm_image_url'];
            }

            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '暂无数据');

        $this->ajaxReturn($data);
    }

    /***********************
    产品列表
    ------------------------
    amdin_id      账户id
    sort          排序
    cid           分类
    goodsName     搜索商品名
    ************************/
    function goodsList()
    {
        //初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id')?:-2;

        //排序条件：1默认，2价格，3时间
        $sort = I('sort')?:1;
        $where = array(
            'total_num' => array('gt',0),
            'is_sale' => 0,
            'admin_id' => $admin_id,
        );
        if (I('cid')) $where['cid'] = I('cid');
        
        if (I('goodsName')) $where['goodsName'] = array('like',"%".trim(I('goodsName'))."%");
        $model = D('Other');
        $result = $model->goods_sort($tableName['goods'],$where,$sort);
       
        if($result) {
            foreach ($result as $key => $value) {
                $result[$key]['image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $value['image_url'];
                $result[$key]['sm_image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $value['sm_image_url'];
            }

            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        }else $data = array('status' => 0, 'msg' => '暂无数据');
        
        $this->ajaxReturn($data);
    }

    //查看商品详情
    function goodsDetails()
    {
        //初始化数据库表
        $tableName = $this->table;
        $result = D('Other')->findData($tableName['goods'], array('id' => I('id')), '');
        if ($result) {
            $result['image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $result['image_url'];
            $result['sm_image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $result['sm_image_url'];
            //记录商品的阅读数据
            $addData = array(
                'goods_id' => $result['id'],
                'click' => 1,
                'create_time' => time(),
                'admin_id' => I('admin_id')
            );
            D('Other')->addData($tableName['goods_view'], $addData);

            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '该商品不存在');

        $this->ajaxReturn($data);
    }

    //新闻分类
    function newsCatorage()
    {
        //初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id')?:-1;
        $result = D('Other')->findAllData($tableName['company_news_type'], array('admin_id' => $admin_id), '');
        if ($result) {
            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '暂无数据');

        $this->ajaxReturn($data);
    }
    //新闻展示
    function newShow()
    {
        //初始化数据库表
        $tableName = $this->table;
        //时间格式的展示：1(.)  2(/) 默认(-)
        $dateType = I('dateType');
        //获取分类ID
        $admin_id = I('admin_id')?:-2;
        $where['admin_id'] = $admin_id;
        if (I('cid')) $where['cid'] = I('cid');
        $result = D('Other')->findAllData($tableName['company_news'], $where, '');
        if ($result) {
            foreach ($result as $key => $value) {
                $result[$key]['image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $value['image_url'];
                $result[$key]['sm_image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $value['sm_image_url'];
                if ($dateType == 1) $result[$key]['create_time'] = date('Y.m.d', $value['create_time']);
                elseif ($dateType == 2) $result[$key]['create_time'] = date('Y/m/d', $value['create_time']);
                else $result[$key]['create_time'] = date('Y-m-d', $value['create_time']);
            }

            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '暂无数据');

        $this->ajaxReturn($data);
    }

    //新闻详情
    function newsDetails()
    {
        //初始化数据库表
        $tableName = $this->table;
        //时间格式的展示：1(.)  2(/) 默认(-)
        $dateType = I('dateType');
        $result = D('Other')->findData($tableName['company_news'], array('id' => I('id')), '');
        if ($result) {
            $result['image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $result['image_url'];
            $result['sm_image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $result['sm_image_url'];
            if ($dateType == 1) $result['create_time'] = date('Y.m.d', $result['create_time']);
            elseif ($dateType == 2) $result['create_time'] = date('Y/m/d', $result['create_time']);
            else $result['create_time'] = date('Y-m-d', $result['create_time']);

            //记录新闻的点击量
            D('Other')->saveIncDec($tableName['company_news'], array('id' => I('id')), 'view', 1, 1);
            //记录新闻的阅读数据
            $addData = array(
                'vid' => $result['id'],
                'click' => 1,
                'create_time' => time(),
                'admin_id' => I('admin_id')
            );
            D('Other')->addData($tableName['componay_news_view'], $addData);
            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '该新闻不存在');

        $this->ajaxReturn($data);
    }

    //关于我们
    function about_us()
    {
        //初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id');
        $model = D('Other');
        $result = D('Other')->findData($tableName['setting_info'], array('admin_id' => $admin_id), '');

        
        if ($result) {
            if ($result['image_url']) $result['image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $result['image_url'];
            if ($result['long']) {
                $tengXun = $this->Convert_BD09_To_GCJ02($result['lat'],$result['long']);
                $result['long'] = $tengXun['lng'];
                $result['lat'] = $tengXun['lat'];
            }
            //查找门店的图片
            $imageArr= $model->findAllData($tableName['frim_image'], array('admin_id' => $admin_id), '', '');
            foreach ($imageArr as $key => $value) {
            	$imageArr[$key]['image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $value['image_url'];
            }

            $result['imageArr'] = $imageArr;

            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '暂无数据');

        $this->ajaxReturn($data);
    }

    //关于我们,百度转腾讯
    //key:开发者密钥,https://lbs.qq.com/console/key.html这里申请
    function about_us_new()
    {
        //初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id');
        $model = D('Other');
        $result = D('Other')->findData($tableName['setting_info'], array('admin_id' => $admin_id), '');

        
        if ($result) {
            if ($result['image_url']) $result['image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $result['image_url'];
            if ($result['long']) {
                /*$tengXun = $this->Convert_BD09_To_GCJ02($result['lat'],$result['long']);
                $result['long'] = $tengXun['lng'];
                $result['lat'] = $tengXun['lat'];*/
                $url = 'https://apis.map.qq.com/ws/coord/v1/translate?locations='.$result['lat'].','.$result['long'].'&type=3&key='.I('key');
                $info = json_decode($this->curlGet($url),1);
                if($info['status'] == 0){
                    $result['long'] = $info['locations']['0']['lng'];
                    $result['lat'] = $info['locations']['0']['lat'];
                }
                
                // $this->ajaxReturn(($info));

            }
            //查找门店的图片
            $imageArr= $model->findAllData($tableName['frim_image'], array('admin_id' => $admin_id), '', '');
            foreach ($imageArr as $key => $value) {
                $imageArr[$key]['image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $value['image_url'];
            }

            $result['imageArr'] = $imageArr;

            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result, 'info' => $info, 'url' => $url);
        } else $data = array('status' => 0, 'msg' => '暂无数据');

        $this->ajaxReturn($data);
    }

    //GPS坐标互换
    public function gps()
    {
        Vendor('Gps.GPS');

        $obj = new \GPS();
        // dump($boj->gcj_encrypt('39.933676862706776', '116.35608315379092'));
    }

/************************************************************
其他地图经纬度转换腾讯地图经纬度
************************************************************/
    /**
     *  参数          说明                                                                                                      示例
     * locations    预转换的坐标，支持批量转换，格式：纬度前，经度后，纬度和经度之间用","分隔，每组坐标之间使用";"分隔；       locations=39.12,116.83;30.21,115.43
     * type         输入的locations的坐标类型
     *              可选值为[1,6]之间的整数，每个数字代表的类型说明： 
     *                  1 GPS坐标
     *                  2 sogou经纬度
     *                  3 baidu经纬度                                                                                          type=3
     *                  4 mapbar经纬度
     *                  5 [默认]腾讯、google、高德坐标
     *                  6 sogou墨卡托
     * key          开发密钥（Key）                                                                                           key=OB4BZ-D4W3U-B7VVO-4PJWW-6TKDJ-WPB77
     *
     *（非必填）
     * output       返回格式：支持JSON/JSONP，默认JSON                                                                            output=json
     * callback     JSONP方式回调函数                                                                                             callback=function1
     *                  
    **/
    /*http://lbs.qq.com/webservice_v1/guide-convert.html*/
    function curlGet($url)
    {
        // 使用 curl_init()函数初始化一个CURL会话，初始化成功后返回一个句柄供curl_setopt(), curl_exec(),和 curl_close() 函数使用
        $curl = curl_init();
        // 使用curl_setopt()设置要获取的URL地址
        curl_setopt($curl, CURLOPT_URL, $url);
        // 设置是否输出header 设为0 否则影响输出
        curl_setopt($curl, CURLOPT_HEADER, 0);
        // 设置是否输出结果
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        // 设置是否输出结果
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        // 设置是否检查服务器端的证书
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        // 使用curl_exec()将CURL返回的结果转换成正常数据并保存到一个变量
        $data = curl_exec($curl);
        // 使用 curl_close() 关闭CURL会话
        curl_close($curl);
        return $data;
    }

    function store()
    {
        //初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id')?:-2;
        $model = D('Other');
        $result = $model->findAllData($tableName['store'], array('admin_id' => $admin_id), '');
        $storeRes = [];
        if ($result) {       
        	foreach ($result as $k => $val) {
        		$tengXun = $this->Convert_BD09_To_GCJ02($val['lat'],$val['long']);
                $result[$k]['long'] = $tengXun['lng'];
                $result[$k]['lat'] = $tengXun['lat'];               
        	}
            

            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '暂无数据');

        $this->ajaxReturn($data);
    }

    function storeDetails()
    {
    	$tableName = $this->table;
        $admin_id = I('admin_id')?:-2;
        $model = D('Other');
        $result = $model->findData($tableName['store'], array('admin_id' => $admin_id, 'id' => I('id')), '');
        if ($result) {
        	if ($result['long']) {
                $tengXun = $this->Convert_BD09_To_GCJ02($result['lat'],$result['long']);
                $result['long'] = $tengXun['lng'];
                $result['lat'] = $tengXun['lat'];
            }
        	//查找门店的图片
            $imageArr= $model->findAllData($tableName['frim_image'], array('admin_id' => $admin_id, 'type' => $result['type']), '', '');
            foreach ($imageArr as $key => $value) {
            	$imageArr[$key]['image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $value['image_url'];
            }

            $result['imageArr'] = $imageArr;
        	$data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '暂无数据');

        $this->ajaxReturn($data);
    }

    //百度地图转化成为正常地图坐标点
    function Convert_BD09_To_GCJ02($lat,$lng){  
        $x_pi = 3.14159265358979324 * 3000.0 / 180.0;  
        $x = $lng - 0.0065;  
        $y = $lat - 0.006;  
        $z = sqrt($x * $x + $y * $y) - 0.00002 * sin($y * $x_pi);  
        $theta = atan2($y, $x) - 0.000003 * cos($x * $x_pi);  
        $lng = $z * cos($theta);  
        $lat = $z * sin($theta);  
        return array('lng'=>$lng,'lat'=>$lat);  
    } 

    //首页广播信息
    function broadcast()
    {
        //初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id')?:-1;
        $result = D('Other')->findAllData($tableName['broadcast'], array('admin_id' => $admin_id), '');
        if ($result) {
            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '暂无数据');

        $this->ajaxReturn($data);
    }

    //咨询类型
    function contactType()
    {
        //初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id')?:-1;
        $result = D('Other')->findAllData($tableName['contact_type'], array('admin_id' => $admin_id), '');
        if ($result) {
            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '暂无数据');

        $this->ajaxReturn($data);
    }
    //提交咨询
    function contactUs()
    {
        //初始化数据库表
        $tableName = $this->table;
        if(I('username') == undefined || I('username') == null || I('username')== ''){$this->ajaxReturn(array('status' => -1, 'msg' => '请填用户名'));die;}
        if(I('phone') == undefined || I('phone') == null || I('phone')== ''){$this->ajaxReturn(array('status' => -1, 'msg' => '请填联系电话'));die;}
        if(I('type') == undefined || I('type') == null || I('type')== ''){$this->ajaxReturn(array('status' => -1, 'msg' => '请选择咨询类型'));die;}
        if(I('content') == undefined || I('content') == null || I('content')== ''){$this->ajaxReturn(array('status' => -1, 'msg' => '请填咨询内容'));die;}
        $addData = array(
            'username' => I('username'),
            'phone' => I('phone'),
            'type' => I('type'),
            'content' => I('content'),
            'create_time' => time(),
            'admin_id' => I('admin_id')
        );
        $result = D('Other')->addData($tableName['contact_us'], $addData);
        if ($result) {
            $data = array('status' => 1, 'msg' => '咨询成功，等待联系', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '咨询失败');

        $this->ajaxReturn($data);
    }
    
}