<?php

namespace Api\Controller;
use Think\Controller;

class GpsController extends Controller{
    protected $table = array();
    private $PI = 3.14159265358979324;
    private $x_pi = 0;

    function __construct(){
        //初始化数据库表
        $tables= array(
            'image_manage' => 'image_manage',
            'goods' => 'goods',
            'company_news' => 'company_news',
            'goods_catorage' => 'goods_catorage',
            'company_news_type' => 'company_news_type',
            'setting' => 'setting',
            'componay_news_view' => 'componay_news_view',
            'goods_view' => 'goods_view',
            'broadcast' => 'broadcast',
            'contact_type' => 'contact_type',
            'contact_us' => 'contact_us',
            'setting_info' => 'setting_info',
            'frim_image' => 'frim_image',
			'store' => 'store'
        );

        $this->x_pi = 3.14159265358979324 * 3000.0 / 180.0;
        return $this->table = $tables;

    }

    //关于我们
    function about_us()
    {
        //初始化数据库表
        $tableName = $this->table;
        $admin_id = I('admin_id');
        $model = D('Other');
        $result = D('Other')->findData($tableName['setting_info'], array('admin_id' => $admin_id), '');

        
        if ($result) {
            if ($result['image_url']) $result['image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $result['image_url'];
            if ($result['long']) {
            	$arr = $this->bd_decrypt($result['lat'],$result['long']);
            	$array = $this->gcj_decrypt_exact($arr['lat'],$arr['lon']);
            	// $arr = $this->gcj_decrypt($result['lat'],$result['long']);

                // $tengXun = $this->Convert_BD09_To_GCJ02($result['lat'],$result['long']);
                $result['long'] = $array['lon'];
                $result['lat'] = $array['lat'];
            }
            //查找门店的图片
            $imageArr= $model->findAllData($tableName['frim_image'], array('admin_id' => $admin_id), '', '');
            foreach ($imageArr as $key => $value) {
            	$imageArr[$key]['image_url'] = "https://" . $_SERVER['HTTP_HOST'] . __ROOT__ . $value['image_url'];
            }

            $result['imageArr'] = $imageArr;

            $data = array('status' => 1, 'msg' => '数据获取成功', 'data' => $result);
        } else $data = array('status' => 0, 'msg' => '暂无数据');

        $this->ajaxReturn($data);
    }

    //BD-09 to GCJ-02
    public function bd_decrypt($bdLat, $bdLon)
    {
        $x = $bdLon - 0.0065; $y = $bdLat - 0.006;  
        $z = sqrt($x * $x + $y * $y) - 0.00002 * sin($y * $this->x_pi);  
        $theta = atan2($y, $x) - 0.000003 * cos($x * $this->x_pi);  
        $gcjLon = $z * cos($theta);  
        $gcjLat = $z * sin($theta);
        return array('lat' => $gcjLat, 'lon' => $gcjLon);
    }

    //GCJ-02 to WGS-84
    public function gcj_decrypt($gcjLat, $gcjLon) {
        if ($this->outOfChina($gcjLat, $gcjLon))
            return array('lat' => $gcjLat, 'lon' => $gcjLon);
         
        $d = $this->delta($gcjLat, $gcjLon);
        return array('lat' => $gcjLat - $d['lat'], 'lon' => $gcjLon - $d['lon']);
    }

    //WGS-84 to GCJ-02
    public function gcj_encrypt($wgsLat, $wgsLon) {
        if ($this->outOfChina($wgsLat, $wgsLon))
            return array('lat' => $wgsLat, 'lon' => $wgsLon);
 
        $d = $this->delta($wgsLat, $wgsLon);
        return array('lat' => $wgsLat + $d['lat'],'lon' => $wgsLon + $d['lon']);
    }

    public function gcj_decrypt_exact($gcjLat, $gcjLon) {
        $initDelta = 0.01;
        $threshold = 0.000000001;
        $dLat = $initDelta; $dLon = $initDelta;
        $mLat = $gcjLat - $dLat; $mLon = $gcjLon - $dLon;
        $pLat = $gcjLat + $dLat; $pLon = $gcjLon + $dLon;
        $wgsLat = 0; $wgsLon = 0; $i = 0;
        while (TRUE) {
            $wgsLat = ($mLat + $pLat) / 2;
            $wgsLon = ($mLon + $pLon) / 2;
            $tmp = $this->gcj_encrypt($wgsLat, $wgsLon);
            $dLat = $tmp['lat'] - $gcjLat;
            $dLon = $tmp['lon'] - $gcjLon;
            if ((abs($dLat) < $threshold) && (abs($dLon) < $threshold))
                break;
 
            if ($dLat > 0) $pLat = $wgsLat; else $mLat = $wgsLat;
            if ($dLon > 0) $pLon = $wgsLon; else $mLon = $wgsLon;
 
            if (++$i > 10000) break;
        }
        //console.log(i);
        return array('lat' => $wgsLat, 'lon'=> $wgsLon);
    }

    private function delta($lat, $lon)
    {
        // Krasovsky 1940
        //
        // a = 6378245.0, 1/f = 298.3
        // b = a * (1 - f)
        // ee = (a^2 - b^2) / a^2;
        $a = 6378245.0;//  a: 卫星椭球坐标投影到平面地图坐标系的投影因子。
        $ee = 0.00669342162296594323;//  ee: 椭球的偏心率。
        $dLat = $this->transformLat($lon - 105.0, $lat - 35.0);
        $dLon = $this->transformLon($lon - 105.0, $lat - 35.0);
        $radLat = $lat / 180.0 * $this->PI;
        $magic = sin($radLat);
        $magic = 1 - $ee * $magic * $magic;
        $sqrtMagic = sqrt($magic);
        $dLat = ($dLat * 180.0) / (($a * (1 - $ee)) / ($magic * $sqrtMagic) * $this->PI);
        $dLon = ($dLon * 180.0) / ($a / $sqrtMagic * cos($radLat) * $this->PI);
        return array('lat' => $dLat, 'lon' => $dLon);
    }

    private function outOfChina($lat, $lon)
    {
        if ($lon < 72.004 || $lon > 137.8347)
            return TRUE;
        if ($lat < 0.8293 || $lat > 55.8271)
            return TRUE;
        return FALSE;
    }

    private function transformLat($x, $y) {
        $ret = -100.0 + 2.0 * $x + 3.0 * $y + 0.2 * $y * $y + 0.1 * $x * $y + 0.2 * sqrt(abs($x));
        $ret += (20.0 * sin(6.0 * $x * $this->PI) + 20.0 * sin(2.0 * $x * $this->PI)) * 2.0 / 3.0;
        $ret += (20.0 * sin($y * $this->PI) + 40.0 * sin($y / 3.0 * $this->PI)) * 2.0 / 3.0;
        $ret += (160.0 * sin($y / 12.0 * $this->PI) + 320 * sin($y * $this->PI / 30.0)) * 2.0 / 3.0;
        return $ret;
    }
 
    private function transformLon($x, $y) {
        $ret = 300.0 + $x + 2.0 * $y + 0.1 * $x * $x + 0.1 * $x * $y + 0.1 * sqrt(abs($x));
        $ret += (20.0 * sin(6.0 * $x * $this->PI) + 20.0 * sin(2.0 * $x * $this->PI)) * 2.0 / 3.0;
        $ret += (20.0 * sin($x * $this->PI) + 40.0 * sin($x / 3.0 * $this->PI)) * 2.0 / 3.0;
        $ret += (150.0 * sin($x / 12.0 * $this->PI) + 300.0 * sin($x / 30.0 * $this->PI)) * 2.0 / 3.0;
        return $ret;
    }

}
