<?php
/**
 * @Author: anchen
 * @Date:   2017-04-14 15:26:58
 * @Last Modified by:   anchen
 * @Last Modified time: 2017-04-14 15:43:31
 */

/*
	文件上传函数
	@param char $dirname 保存的子目录名字
 */

function upload($dirname){
	$upload = new \Think\Upload();// 实例化上传类
    $upload->maxSize   =     3145728 ;// 设置附件上传大小
    $upload->exts      =     array('jpg', 'gif', 'png', 'jpeg');// 设置附件上传类型
    $upload->rootPath  =     './Uploads/'; // 设置附件上传根目录
    $upload->subName  =     $dirname; // 设置附件上传（子）目录
    $upload->autoSub   =     true;
    $info = $upload -> upload();
    // dump($info);
    if (!$info) {
    	$result = array(
            'status' => 0,
            'error' => $upload->getError()
        );
    }else{
    	foreach($info as $file){
        	$savename[] = '/Uploads/'.$file['savepath'] . $file['savename'];
    	}
    	$result = array(
            'status' => 1,
            'result' => implode(',',$savename)
        );
    }

    return $result;
}
/*
    前端string转化为数组处理
    @param char $arr 前端数组
 */
function stringToarr($strings)
{
    $string = str_replace('[', '', $strings);
    $string = str_replace(']', '', $string);
    $string = str_replace('"', '', $string);
    $arr = explode(',', $string);
    foreach ($arr as $key => $value) {
        $arr[$key] = str_replace('"', '', $value);
        $arr[$key] = str_replace('"', '', $arr[$key]);
    }

    return $arr;
}
/*
    前端图片路径过滤处理
    @param char $arr 图片路径
 */
function imgFilter($image)
{
    //图片的反斜杠处理
    $image_url = str_replace('"', '', $image);
    $image_url = str_replace('\/', '/', $image_url);
    $image_url = str_replace('\\', '', $image_url);
    $image_url = str_replace(']', '', $image_url);
    $image_url = str_replace('[', '', $image_url);

    return $image_url;
}

function alertMsg($msg = "", $url = "")
{
    if (!$url) {
        if ($_SERVER['HTTP_REFERER']) {
            echo "<script>alert('{$msg}');location.href='{$_SERVER['HTTP_REFERER']}';</script>";die;
        } else {
            echo "<script>alert('{$msg}');location.href=history.back();</script>";die;
        }
    } else {
        echo "<script>alert('{$msg}');location.href='{$url}';</script>";die;
    }
}
/**
 * Get 请求 模拟登陆
 * @param  string $url 访问链接
 * @return mix
 */
function curlGet($url)
{
    // 使用 curl_init()函数初始化一个CURL会话，初始化成功后返回一个句柄供curl_setopt(), curl_exec(),和 curl_close() 函数使用
    $curl = curl_init();
    // 使用curl_setopt()设置要获取的URL地址
    curl_setopt($curl, CURLOPT_URL, $url);
    // 设置是否输出header 设为0 否则影响输出
    curl_setopt($curl, CURLOPT_HEADER, 0);
    // 设置是否输出结果
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    // 设置是否输出结果
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    // 设置是否检查服务器端的证书
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    // 使用curl_exec()将CURL返回的结果转换成正常数据并保存到一个变量
    $data = curl_exec($curl);
    // 使用 curl_close() 关闭CURL会话
    curl_close($curl);
    return $data;
}
function curlPost($url, $data){
    $curl = curl_init(); // 启动一个CURL会话
    curl_setopt($curl, CURLOPT_URL, $url); // 要访问的地址
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0); // 对认证证书来源的检查
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 1); // 从证书中检查SSL加密算法是否存在
    curl_setopt($curl, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']); // 模拟用户使用的浏览器
    curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1); // 使用自动跳转
    curl_setopt($curl, CURLOPT_AUTOREFERER, 1); // 自动设置Referer
    curl_setopt($curl, CURLOPT_POST, 1); // 发送一个常规的Post请求
    curl_setopt($curl, CURLOPT_POSTFIELDS, $data); // Post提交的数据包
    curl_setopt($curl, CURLOPT_TIMEOUT, 30); // 设置超时限制防止死循环
    curl_setopt($curl, CURLOPT_HEADER, 0); // 显示返回的Header区域内容
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1); // 获取的信息以文件流的形式返回
    $tmpInfo = curl_exec($curl); // 执行操作
    if (curl_errno($curl)) {
       echo 'Errno'.curl_error($curl);//捕抓异常
    }
    curl_close($curl); // 关闭CURL会话
    return $tmpInfo; // 返回数据
}

function curl_getToken()
{
    $url = 'http://www.quanmintanlu.com/carbon_api';
    $data = '{"cmd":"get.service.token","appKey":"aeb2ed278e32465c8673248c97d6167c","appId":"1502125296","ver":1}';
    $data = curlPost($url,$data);
    $obj = json_decode($data);
    if (($obj -> err) == 0) {
        $token = $obj -> token;
        S('wx_token', $token, 7200);
        return 1;
    }    
    else return 0;
}

/**
 * 二维数组的排序
 * @param  arr $arr 二维数组
 * @param  string $str 某个字段
 * @return Array 排序后的数组
 */
function twoArrSort($arr, $str){
    $falg = 0;
    foreach ($arr as $key => $value) {
        if ($value[$str] < $arr[$key+1][$str]) {
            $falg = 1;
            $temp = $value;
            $arr[$key] = $arr[$key+1];
            $arr[$key+1] = $temp;
        }
    }
    //递归循环判断
    if ($falg == 1)
        $newArr = twoArrSort($arr, $str);
    else
        $newArr = $arr;

    return $newArr;
}