<?php
namespace Admin\Model;
use Think\Model;
class OrtherModel extends Model 
{
  
    //初始化数据库表
    protected  $tableName = 'effect_goods';
    private $table = '';

    //添加数据
    function addData($tableName, $data)
    {
        return M($tableName)->add($data);
    }

    //删除数据
    function deleData($tableName, $where)
    {
        return M($tableName)->where($where)->delete();
    }

    //修改数据
    function saveData($tableName, $where, $data)
    {
        return M($tableName)->where($where)->save($data);
    }

    //查找单个数据
    function findData($tableName, $where, $field)
    {
        return M($tableName)->field($field)->where($where)->find();
    }

    //查找全部数据
    function findAllData($tableName, $where, $field, $num)
    {
        return M($tableName)->field($field)->where($where)->order('id desc')->limit($num)->select();
    }

    //查找单个字段
    function getFieldData($tableName, $where, $string)
    {
        return M($tableName)->where($where)->getField($string);
    }

    //分页功能
    function getPage($tableName, $where, $field, $num)
    {

        $count = M($tableName)->where($where)->count();
        $Page = new \Think\Page($count, $num);
        $count = $count?:0;
        $p = ceil($count/$num)?:1;
        $page= $Page->show();
        if ($tableName == 'attr_value') {
            $where1 = '';
            if ($where['admin_id']) $where['m.admin_id'] = $where['admin_id'];
            $result = M($tableName)->field('m.*, j.attr')->join("m LEFT JOIN `tbl_attr` j ON j.id = m.attr_id")->where($where)->order('m.create_time desc')->limit($Page->firstRow.','.$Page->listRows)->select();
        } elseif ($tableName == 'goods') {
            $where1 = '';
            if ($where['admin_id']) $where1['m.admin_id'] = $where['admin_id'];
            if ($where['goodsName']) $where1['m.goodsName'] = $where['goodsName'];
            if ($where['cid']) $where1['j.id'] = $where['cid'];
            $result = M($tableName)->field('m.*, j.cat_name')->join('m LEFT JOIN `tbl_goods_catorage` j ON j.id = m.cid')->where($where1)->order('m.create_time desc')->limit($Page->firstRow.','.$Page->listRows)->select();
        } elseif ($tableName == 'company_news') {
            $where1 = '';
            if ($where['admin_id']) $where1['m.admin_id'] = $where['admin_id'];
            if ($where['title']) $where1['m.title'] = $where['title'];
            if ($where['cid']) $where1['j.id'] = $where['cid'];
            $result = M($tableName)->field('m.*, j.type')->join('m LEFT JOIN `tbl_company_news_type` j ON j.id = m.cid')->where($where1)->order('m.create_time desc')->limit($Page->firstRow.','.$Page->listRows)->select();
        } elseif ($tableName == 'contact_us') {
            $where1 = '';
            if ($where['admin_id']) $where1['m.admin_id'] = $where['admin_id'];
            if ($where['type']) $where1['m.type'] = $where['type'];
            $result = M($tableName)->field('m.id, m.username, m.phone, m.content, m.create_time, j.type')->join('m LEFT JOIN `tbl_contact_type` j ON j.id = m.type')->where($where1)->order('m.create_time desc')->limit($Page->firstRow.','.$Page->listRows)->select();
        } elseif ($tableName == 'system') {
            $result = M($tableName)->field('m.*, j.username')->join('m LEFT JOIN `tbl_admin_users` j ON j.id = m.admin_id')->order('id desc')->where($where1)->limit($Page->firstRow.','.$Page->listRows)->select();
        } else {
            $result = M($tableName)->field($field)->where($where)->order('create_time desc')->limit($Page->firstRow.','.$Page->listRows)->select();
        }
        $page = $page? : '<ul class="am-pagination"><li>  </li></ul>';
        $pageString = '<li class="page-li">总共'.$p.'页'.$count.'条记录</li></ul>';
        $page = str_replace('</ul>', $pageString, $page);

        return array('page' => $page, 'result' => $result);
    }



}