<?php
namespace Admin\Model;
use Think\Model;
class CommonModel extends Model 
{
  
    //初始化数据库表
    protected  $tableName = 'effect_goods';
    private $table = '';

    //根据session来设置当前的数据库表
    function setTable()
    {
        session_start();
        $table = session('tableName');

        $this->table = $table;
    }

    //添加数据
    function addData($data)
    {
        $this->setTable();

        return M($this->table)->add($data);
    }

    //删除数据
    function deleData($where)
    {
        $this->setTable();

        return M($this->table)->where($where)->delete();
    }

    //修改数据
    function saveData($where, $data)
    {
        $this->setTable();

        return M($this->table)->where($where)->save($data);
    }

    //查找单个数据
    function findData($where, $field)
    {
        $this->setTable();
        $type = session('tableName');

        return M($this->table)->field($field)->where($where)->find();
    }

    //查找全部数据
    function findAllData($where, $field, $num)
    {
        $this->setTable();
        $type = session('tableName');

        return M($this->table)->field($field)->where($where)->limit($num)->select();
    }

    //查找单个字段
    function getFieldData($where, $string)
    {
        $this->setTable();

        return M($this->table)->where($where)->getField($string);
    }

    //分页功能
    function getPage($where, $field, $num)
    {
        $this->setTable();

        $count = M($this->table)->where($where)->count();
        $Page = new \Think\Page($count, $num);
        $count = $count?:0;
        $p = ceil($count/$num)?:1;
        $page= $Page->show();
        $result = M($this->table)->field($field)->where($where)->order('create_time desc')->limit($Page->firstRow.','.$Page->listRows)->select();
        $page = $page? : '<ul class="am-pagination"><li></li></ul>';
        $pageString = '<li class="page-li">总共'.$p.'页'.$count.'条记录</li></ul>';
        $page = str_replace('</ul>', $pageString, $page);

        return array('page' => $page, 'result' => $result);
    }



}