<?php
namespace Admin\Controller;
use Think\Controller;
class StatisticsController extends BaseController {

    protected $table = array();
    function __construct(){
        parent::__construct();
        //初始化数据库表
        $tables= array(
            'wx_users' => 'wx_users',
            'company_news' => 'company_news',
            'goods' => 'goods',
            'goods_view' => 'goods_view'
        );
        return $this->table = $tables;
    }
/*------------------------------------------数据统计-------------------------------------------*/
    function userInfo()
    {       
        auth_alert("userInfo_list_w"); 
        auth_check("fatting_list_read");
        $this->assign('edit_auth',auth_check("fatting_list_edit",true));

        //初始化数据库表]
        $tableName = $this->table;
        $admin_id = session('admin_id')?:-1;

        $begindate = I('get.begindate');
        $enddate = I('get.enddate');
        $begintime = strtotime($begindate);
        $endtime = strtotime($enddate);

        if(!($begindate && $enddate)){
            $begindate = date('Y-m-d',time()-24*3600*30);
            $enddate = date('Y-m-d',time());
            $begintime = strtotime($begindate);
            $endtime = strtotime($enddate)+24*3600;
        }

        $field = 'create_time';
        $where['create_time'] = array('between',array($begintime,$endtime));
        if ($admin_id != 1) $where['admin_id'] = $admin_id;
        $result = IntervalStatistics('wx_users',$where,$field,'create_time',$begintime,$endtime);   //区间统计
        
        $this->assign(array(
            'result' => $result,
            'begindate' => $begindate,
            'enddate' => $enddate
        ));
        $this->display('userInfo');
    }
/*==========================================数据统计============================================*/
/*------------------------------------------企业新闻-------------------------------------------*/
    function newslist()
    {
        auth_alert("newslist_list_w"); 
        auth_check("fatting_list_read");
        $this->assign('edit_auth',auth_check("fatting_list_edit",true));
        //初始化数据库表]
        $tableName = $this->table;
        $admin_id = session('admin_id')?:-1;

        if ($admin_id != 1) $where['admin_id'] = $admin_id;
        if (I('title')) $where['title'] = array('like', '%'.I('title').'%');
        if (I('cid')) $where['cid'] = I('cid');
        $result = D('Orther')->getPage($tableName['company_news'], $where, '', 5);
        foreach ($result['result'] as $key => $value) {
            $result['result'][$key]['create_time'] = date('Y-m-d H:i', $value['create_time']);
        }

        $this->assign(array(
            'result' => $result['result'],
            'page' => $result['page']
        ));

        $this->display();
    }
    function newsInfo()
    {       
        auth_alert("newslist_list_w"); 
        auth_check("fatting_list_read");
        $this->assign('edit_auth',auth_check("fatting_list_edit",true));

        //初始化数据库表]
        $tableName = $this->table;
        $admin_id = session('admin_id')?:-1;

        $begindate = I('get.begindate');
        $enddate = I('get.enddate');
        $begintime = strtotime($begindate);
        $endtime = strtotime($enddate);

        if(!($begindate && $enddate)){
            $begindate = date('Y-m-d',time()-24*3600*30);
            $enddate = date('Y-m-d',time());
            $begintime = strtotime($begindate);
            $endtime = strtotime($enddate)+24*3600;
        }
        
        $field = 'create_time';
        $where = '';
        $where['create_time'] = array('between',array($begintime,$endtime));
        $where['vid'] = I('id');
        if ($admin_id != 1) $where['admin_id'] = $admin_id;
        $result = IntervalStatistics('componay_news_view',$where,$field,'create_time',$begintime,$endtime);   //区间统计
        
        $this->assign(array(
            'result' => $result,
            'begindate' => $begindate,
            'enddate' => $enddate
        ));
        $this->display('newsInfo');
    }
/*==========================================企业新闻============================================*/

/*------------------------------------------商城管理-------------------------------------------*/
    public function goodslist()
    {
        auth_alert("goodslist_list_w"); 
        auth_check("fatting_list_read");
        $this->assign('edit_auth',auth_check("fatting_list_edit",true));

        //初始化数据库表]
        $tableName = $this->table;
        $admin_id = session('admin_id')?:-1;
        $where = '';
        if ($admin_id != 1) $where['admin_id'] = $admin_id;
        if (I('goodsName')) $where['goodsName'] = array('like', '%'.I('goodsName').'%');
        $result = D('Orther')->getPage($tableName['goods'], $where, '', 8);
        //商品的阅读量
        foreach ($result['result'] as $key => $value) {
            $result['result'][$key]['click'] =M('goods_view')->where(array('goods_id' => $value['id']))->count();
        }

        $this->assign(array('result' => $result['result'], 'page' => $result['page']));
        $this->display();
    }

    function goodsInfo()
    {       
        auth_alert("goodslist_list_w"); 
        auth_check("fatting_list_read");
        $this->assign('edit_auth',auth_check("fatting_list_edit",true));

        //初始化数据库表]
        $tableName = $this->table;
        $admin_id = session('admin_id')?:-1;

        $begindate = I('get.begindate');
        $enddate = I('get.enddate');
        $begintime = strtotime($begindate);
        $endtime = strtotime($enddate);

        if(!($begindate && $enddate)){
            $begindate = date('Y-m-d',time()-24*3600*30);
            $enddate = date('Y-m-d',time());
            $begintime = strtotime($begindate);
            $endtime = strtotime($enddate)+24*3600;
        }
        
        $field = 'create_time';
        $where['create_time'] = array('between',array($begintime,$endtime));
        $where['admin_id'] = $admin_id;
        if ($admin_id != 1) $where['goods_id'] = I('id');
        $result = IntervalStatistics('goods_view',$where,$field,'create_time',$begintime,$endtime);   //区间统计
        
        $this->assign(array(
            'result' => $result,
            'begindate' => $begindate,
            'enddate' => $enddate
        ));
        $this->display('goodsInfo');
    }
/*==========================================商城管理============================================*/
}