<?php
namespace Admin\Controller;
use Think\Controller;
class SettingController extends BaseController {

    protected $table = [];
    function __construct(){
        parent::__construct();
        //初始化数据库表
        $tables= [
            'image_manage' => 'image_manage',
            'setting' => 'setting',
            'broadcast' => 'broadcast',
            'contact_type' => 'contact_type',
            'contact_us' => 'contact_us',
            'setting_info' => 'setting_info',
            'frim_image' => 'frim_image',
            'server_list' => 'server_list'
        ];
        return $this->table = $tables;
    }
/*------------------------------------------图片管理-------------------------------------------*/
    function image_manage()
    {
        auth_alert("image_manage_list_w"); 
        auth_check("fatting_list_read");
        $this->assign('edit_auth',auth_check("fatting_list_edit",true));
        $admin_id = session('admin_id')?:-1;

        //初始化数据库表]
        $tableName = $this->table;
        if (IS_POST) {
            $data = [
                'cid' => I('cid'),
                'sort' => I('sort'),
                'admin_id' => $admin_id
            ];

            //判断是否有图片生成
            if (isUpload('image_manage')) {
                $return = upload('image_manage');
                if ($return['status'] == 1) $data['image_url'] = $return['result'];
                else {$this->error($return['error'], '', 2);die;}
            }
            if (!I('id') && !$data['image_url']) {$this->error('图片上传失败', '', 2);die;}
            if (I('id')) {
                if ($data['image_url']) {
                    $check = D('Orther')->findData($tableName['image_manage'], array('id' => I('id')));
                    unlink('.' . $check['image_url']);
                }
                D('Orther')->saveData($tableName['image_manage'], array('id' => I('id')), $data);
                $this->success('保存成功', '', 2);die;
            } else {
                $data['create_time'] = time();
                $result = D('Orther')->addData($tableName['image_manage'], $data);
                if ($result) {$this->success('保存成功','', 2);die;}
                else {$this->error('保存失败', '', 2);die;}
            }
        }
        $where['cid'] = array('neq', 2);
        if ($admin_id != 1) $where['admin_id'] = $admin_id;
        $result = D('Orther')->getPage($tableName['image_manage'], $where, '', 6);
        // dump($result);die;
        $this->assign(array('result' => $result['result'],'page' => $result['page']));
        $this->display();
    }

    function deleImage()
    {
        //初始化数据库表]
        $tableName = $this->table;
        $model = D('Orther');
        $admin_id = session('admin_id')?:-1;
        //删除数据
        if (IS_AJAX) {
            if (I('type') == 1) {
                $table_name = $tableName['frim_image'];
            } elseif (I('type') == 3) {
                $table_name = $tableName['server_list'];
            } else {
                $table_name = $tableName['image_manage'];
            }
            $res = $model->deleData($table_name, ['id' => I('id'), 'admin_id' => $admin_id]);
            if ($res) {
                $url = I('url');
                unlink('.' . $url);
                $msg = ['status' => 1, 'msg' => '删除成功！'];
                $this->ajaxReturn($msg);die;
            } else {
                $msg = ['status' => 0, 'msg' => '删除失败'];
                $this->ajaxReturn($msg);die;
            }

        }
    }
/*==========================================图片管理============================================*/
/*------------------------------------------咨询类型-------------------------------------------*/
    function contactus()
    {
        auth_alert("contactus_list_w"); 
        auth_check("fatting_list_read");
        $this->assign('edit_auth',auth_check("fatting_list_edit",true));

        //初始化数据库表]
        $tableName = $this->table;     
        $admin_id = session('admin_id')?:-1;
        $where = '';
        if ($admin_id != 1) $where['admin_id'] = $admin_id;
        if (I('typeid')) $where['type'] = I('typeid');   
        $result = D('Orther')->getPage($tableName['contact_us'], $where, '', 8); 
        foreach ($result['result'] as $key => $value) {
        	if (strlen($value['content']) > 20) {
        		$result['result'][$key]['str_content'] = my_substr($value['content'], 0, 20) . '...';
        	} else {
        		$result['result'][$key]['str_content'] = $value['content'];
        	}
        }

        //咨询类型
        $where1 = '';
        if ($admin_id != 1) $where1['admin_id'] = $admin_id;
        $typelist = D('Orther')->findAllData($tableName['contact_type'], $where1, '','');
        $this->assign(array(
            'result' => $result['result'],
            'page' => $result['page'],
            'typelist' => $typelist
        ));
        $this->display();
    }
/*==========================================咨询类型============================================*/
/*------------------------------------------咨询类型-------------------------------------------*/
    function contact_type()
    {
        auth_alert("contact_type_list_w"); 
        auth_check("fatting_list_read");
        $this->assign('edit_auth',auth_check("fatting_list_edit",true));

        //初始化数据库表]
        $tableName = $this->table;
        $admin_id = session('admin_id')?:-1;
        $id = I('id')?:0;
        if (I('op') == 'save') {
            $data['type'] = I('type');
            $data['admin_id'] = $admin_id;
            if (empty($data['type'])) {$this->ajaxReturn('信息不完整');die;}
            if ($id) {
                D('Orther')->saveData($tableName['contact_type'], array('id' => $id), $data);
                $this->ajaxReturn(1);die;
            } else {
                $data['create_time'] = time();
                $res = D("Orther")->addData($tableName['contact_type'], $data);
                if ($res) {$this->ajaxReturn(1);die;}
                else {$this->ajaxReturn('操作失败');die;}
            }
        }
        if (I('op') == 'dele') {
            $res = D('Orther')->deleData($tableName['contact_type'], array('id' => $id, 'admin_id' => $admin_id));
            if ($res) {
                $this->ajaxReturn(array('status' => 1, 'msg' => '删除成功'));die;
            }
            else {$this->ajaxReturn(array('status' => 0, 'msg' => '删除失败'));die;}
        }
        $where = '';
        if ($admin_id != 1) $where['admin_id'] = $admin_id;
        $result = D('Orther')->getPage($tableName['contact_type'], $where, '', 8); 

        $this->assign(array(
            'result' => $result['result'],
            'page' => $result['page']
        ));
        $this->display();
    }
/*==========================================咨询类型============================================*/

/*------------------------------------------广播信息-------------------------------------------*/
    function broadcast()
    {
        auth_alert("broadcast_list_w"); 
        auth_check("fatting_list_read");
        $this->assign('edit_auth',auth_check("fatting_list_edit",true));

        //初始化数据库表]
        $tableName = $this->table;
        $admin_id = session('admin_id')?:-1;
        $id = I('id')?:0;
        if (I('op') == 'save') {
            $data['sort'] = I('sort');
            $data['content'] = I('content');
            $data['admin_id'] = $admin_id;
            if (empty($data['content'])) {$this->ajaxReturn('信息不完整');die;}
            if ($id) {
                D('Orther')->saveData($tableName['broadcast'], array('id' => $id), $data);
                $this->ajaxReturn(1);die;
            } else {
                $data['create_time'] = time();
                $res = D("Orther")->addData($tableName['broadcast'], $data);
                if ($res) {$this->ajaxReturn(1);die;}
                else {$this->ajaxReturn('操作失败');die;}
            }
        }
        if (I('op') == 'dele') {
            $res = D('Orther')->deleData($tableName['broadcast'], array('id' => $id, 'admin_id' => $admin_id));
            if ($res) {
                $this->ajaxReturn(array('status' => 1, 'msg' => '删除成功'));die;
            }
            else {$this->ajaxReturn(array('status' => 0, 'msg' => '删除失败'));die;}
        }
        $where = '';
        if ($admin_id != 1) $where['admin_id'] = $admin_id;
        $result = D('Orther')->getPage($tableName['broadcast'], $where, '', 8); 

        $this->assign(array(
            'result' => $result['result'],
            'page' => $result['page']
        ));
        $this->display();
    }
/*==========================================广播信息============================================*/

/*------------------------------------------联系我们-------------------------------------------*/
    function contact_us(){
        auth_alert("contact_us_list_w"); 
        auth_check("fatting_list_read");
        $this->assign('edit_auth',auth_check("fatting_list_edit",true));
        $id = I('id')?:0;
        //初始化数据库表]
        $tableName = $this->table;
        $admin_id = session('admin_id')?:-1;
        $model = D('Orther');
        if(IS_AJAX){
        	//检查用户是否存在
        	$check = $model->findData($tableName['setting_info'], array('admin_id' => $admin_id), '');
            $data = array(
                'long' => I('long'),
                'address' => I('address'),
                'lat' => I('lat'),
                'phone' => I('phone'),
                'work_time' => I('work_time')
            );   
            if ($check) {
            	$model->saveData($tableName['setting_info'], array('admin_id' => $admin_id), $data);
            	$this->ajaxReturn(1);die;
            }  else {
                $data['admin_id'] = $admin_id;
            	$data['create_time'] = time();
            	$re = $model->addData($tableName['setting_info'], $data);
            	if ($re) {
            		$this->ajaxReturn(1);
            	} else {
            		$this->ajaxReturn('操作失败');die;
            	}
            }
        }

        $result = $model->findData($tableName['setting_info'], array('admin_id' => $admin_id));

        $this->assign('result', $result);
        $this->display();
    }
/*==========================================联系我们============================================*/
  
/*------------------------------------------关于我们-------------------------------------------*/
    function about_us()
    {
        auth_alert("about_us_list_w"); 
        auth_check("fatting_list_read");
        $this->assign('edit_auth',auth_check("fatting_list_edit",true));
        //初始化数据库表]
        $tableName = $this->table;
        $admin_id = session('admin_id')?:-1;
        $model = D('Orther');
        if(I('op') == 'add') {
            if (!I('about_us')) {$this->error('内容不能为空', '', 2);die;}
            $data['about_us'] = I('about_us');
            $data['image_url'] = I('url');
            if (isUpload('us_image')) {
                $return = upload('us_image');
                if ($return['status'] == 1){
                    unlink('.' . I('url'));
                    $data['image_url'] = $return['result'];
                }
                else {$this->error($return['error'], '', 2);die;}
            }
            //检查用户是否存在
        	$check = $model->findData($tableName['setting_info'], array('admin_id' => $admin_id), '');
        	if ($check) {
            	$model->saveData($tableName['setting_info'], array('admin_id' => $admin_id), $data);
            	$this->success('操作成功', '', 2);die;
            }  else {
                $data['admin_id'] = $admin_id;
            	$data['create_time'] = time();
            	$re = $model->addData($tableName['setting_info'], $data);
            	if ($re) {
            		$this->success('操作成功', '', 2);die;
            	} else {
            		$this->error('操作失败', '', 2);die;
            	}
            }
        }

        $result = D('Orther')->findData($tableName['setting_info'], array('admin_id' => $admin_id), '');

        $this->assign('result', $result);
        $this->display();
    }


    function about_us_super()
    {
        auth_alert("about_us_super_w"); 
        auth_check("fatting_list_read");
        $this->assign('edit_auth',auth_check("fatting_list_edit",true));
        //初始化数据库表]
        $tableName = $this->table;
        $admin_id = session('admin_id')?:-1;
        $model = D('Orther');

        if(I('op') == 'add') {
            if (!I('about_us')) {$this->error('内容不能为空', '', 2);die;}
            $data['about_us'] = I('about_us');
            $data['image_url'] = I('url');
            if (isUpload('us_image')) {
                $return = upload('us_image');
                if ($return['status'] == 1){
                    unlink('.' . I('url'));
                    $data['image_url'] = $return['result'];
                }
                else {$this->error($return['error'], '', 2);die;}
            }
            //检查用户是否存在
            $check = $model->findData($tableName['setting_info'], array('admin_id' => $admin_id), '');
            if ($check) {
                $model->saveData($tableName['setting_info'], array('admin_id' => $admin_id), $data);
                $this->success('操作成功', '', 2);die;
            }  else {
                $data['admin_id'] = $admin_id;
                $data['create_time'] = time();
                $re = $model->addData($tableName['setting_info'], $data);
                if ($re) {
                    $this->success('操作成功', '', 2);die;
                } else {
                    $this->error('操作失败', '', 2);die;
                }
            }
        }

        $result = $model->findData($tableName['setting_info'], array('admin_id' => $admin_id), '');
        $imgArr = $model->findAllData($tableName['frim_image'], array('admin_id' => $admin_id), '', '');
        $this->assign('imgArr', $imgArr);

        $this->assign('result', $result);
        $this->display();
    }

    //设置客服电话
    function set_about_us()
    {
        //初始化数据库表]
        $tableName = $this->table;
        $admin_id = session('admin_id')?:-1;
        $model = D('Orther');

        if (IS_AJAX) {
            $data['service_tel'] = I('service_tel');
            //检查用户是否存在
        	$check = $model->findData($tableName['setting_info'], array('admin_id' => $admin_id), '');
            if ($check) {
            	$model->saveData($tableName['setting_info'], array('admin_id' => $admin_id), $data);
            	$this->ajaxReturn(1);die;
            }  else {
                $data['admin_id'] = $admin_id;
            	$data['create_time'] = time();
            	$re = $model->addData($tableName['setting_info'], $data);
            	if ($re) {
            		$this->ajaxReturn(1);
            	} else {
            		$this->ajaxReturn('操作失败');die;
            	}
            }
        }
    }

    //门店图片上传
    function do_iamge()
    {
        //初始化数据库表]
        $tableName = $this->table;
        $admin_id = session('admin_id')?:-1;
        $model = D('Orther');
        if (isUpload('firm_image')) {
            $return = uploads('firm_image');
            if ($return['status'] == 1){
                $imgList = $return['result'];
                foreach ($imgList as $value) {
                    $data = [
                        'admin_id' => $admin_id,
                        'image_url' => $value,
                        'create_time' => time()
                    ];
                    $model->addData($tableName['frim_image'], $data);
                }
                $this->success('操作成功', '', 2);die;
            } else {
                $this->error($return['error'], '', 2);die;
            }

        } else {
            $this->error('操作失败', '', 2);die;
        }
    }
/*==========================================关于我们============================================*/

}